/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.csv.logger.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HtmlElement {
    protected String PREFIX = "<";
    protected String tag;
    protected String SUFFIX1 = ">\n";
    protected String SUFFIX2 = ">";
    protected String close = "/";
    protected String start;
    protected String end;
    protected static final String INDENT = "  ";
    protected List<HtmlElement> contents = new ArrayList<HtmlElement>();
    protected Map<String, String> attributeValues = new HashMap<String, String>();
    protected String data = null;

    public HtmlElement(String tag) {
        this.tag = tag;
    }

    public HtmlElement(String tag, String attr, String val) {
        this.tag = tag;
        this.attributeValues.put(attr, val);
    }

    public void add(HtmlElement element) {
        this.contents.add(element);
    }

    public String getContents(String indent) {
        indent = String.valueOf(indent) + INDENT;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.contents.size()) {
            HtmlElement element = this.contents.get(i);
            buf.append(String.valueOf(indent) + element.open());
            String data = element.getData();
            if (data != null) {
                buf.append(data);
            }
            buf.append(element.getContents(indent));
            if (element.data == null) {
                buf.append(indent);
            }
            buf.append(element.close());
            ++i;
        }
        return buf.toString();
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void addAttribute(String attr, String value) {
        this.attributeValues.put(attr, value);
    }

    public String open() {
        StringBuffer element = new StringBuffer();
        element.append(this.PREFIX);
        element.append(this.tag);
        if (this.attributeValues.size() >= 1) {
            Iterator<String> iter = this.attributeValues.keySet().iterator();
            while (iter != null && iter.hasNext()) {
                String attr = iter.next();
                String value = "\"" + this.attributeValues.get(attr) + "\"";
                element.append(" " + attr + "=" + value);
            }
        }
        if (this.data == null) {
            element.append(this.SUFFIX1);
        } else {
            element.append(this.SUFFIX2);
        }
        return element.toString();
    }

    public String close() {
        StringBuffer element = new StringBuffer();
        element.append(this.PREFIX);
        element.append(this.close);
        element.append(this.tag);
        element.append(this.SUFFIX1);
        return element.toString();
    }
}

