/**
 * Copyright (c) 2014, 2019 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppDocumentation;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.CppInit;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Emit C++ enumerations
 */
@SuppressWarnings("all")
public class CppEnumerations {
  public static CharSequence CppEnumerationDefinition(final Enumeration enumeration) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _CppElementDoc = CppDocumentation.CppElementDoc(enumeration);
    _builder.append(_CppElementDoc);
    _builder.newLineIfNotEmpty();
    {
      boolean _c11ClassEnum = CppCodeGenUtils.getC11ClassEnum(enumeration);
      if (_c11ClassEnum) {
        _builder.append("enum class");
      } else {
        _builder.append("enum");
      }
    }
    _builder.append(" ");
    String _name = enumeration.getName();
    _builder.append(_name);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      EList<EnumerationLiteral> _ownedLiterals = enumeration.getOwnedLiterals();
      boolean _hasElements = false;
      for(final EnumerationLiteral literal : _ownedLiterals) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t");
        }
        _builder.append("\t");
        CharSequence _CppElementDoc_1 = CppDocumentation.CppElementDoc(literal);
        _builder.append(_CppElementDoc_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name_1 = literal.getName();
        _builder.append(_name_1, "\t");
        String _defaultValue = CppEnumerations.defaultValue(literal);
        _builder.append(_defaultValue, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  public static String defaultValue(final EnumerationLiteral literal) {
    String _xifexpression = null;
    ValueSpecification _specification = literal.getSpecification();
    boolean _tripleNotEquals = (_specification != null);
    if (_tripleNotEquals) {
      String _stringValue = literal.getSpecification().stringValue();
      _xifexpression = (" = " + _stringValue);
    } else {
      String _xifexpression_1 = null;
      boolean _hasStereotype = GenUtils.hasStereotype(literal, CppInit.class);
      if (_hasStereotype) {
        int _value = UMLUtil.<CppInit>getStereotypeApplication(literal, CppInit.class).getValue();
        _xifexpression_1 = (" = " + Integer.valueOf(_value));
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
}
