/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx.services.internal;

import com.google.common.collect.Range;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.collections.FXCollections;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.eclipse.fx.code.editor.Constants;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.SourceSelection;
import org.eclipse.fx.code.editor.fx.services.CompletionProposalPresenter;
import org.eclipse.fx.code.editor.services.BehaviorContributor;
import org.eclipse.fx.code.editor.services.CompletionProposal;
import org.eclipse.fx.code.editor.services.EditorOpener;
import org.eclipse.fx.code.editor.services.HoverInformationProvider;
import org.eclipse.fx.code.editor.services.NavigationProvider;
import org.eclipse.fx.code.editor.services.ProposalComputer;
import org.eclipse.fx.code.editor.services.SearchProvider;
import org.eclipse.fx.core.AppMemento;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.navigation.NavigationRegion;
import org.eclipse.fx.text.navigation.NavigationTarget;
import org.eclipse.fx.text.ui.Feature;
import org.eclipse.fx.text.ui.ITextHover;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistContextData;
import org.eclipse.fx.text.ui.contentassist.ContentAssistant;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.text.ui.contentassist.IContentAssistant;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.contentassist.IContextInformationValidator;
import org.eclipse.fx.text.ui.presentation.IPresentationReconciler;
import org.eclipse.fx.text.ui.presentation.PresentationReconciler;
import org.eclipse.fx.text.ui.source.AnnotationPresenter;
import org.eclipse.fx.text.ui.source.ISourceViewer;
import org.eclipse.fx.text.ui.source.SourceViewerConfiguration;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.TriggerActionMapping;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class DefaultSourceViewerConfiguration
extends SourceViewerConfiguration {
    private final Input<?> input;
    private final PresentationReconciler reconciler;
    private final ProposalComputer proposalComputer;
    private final IAnnotationModel annotationModel;
    private final AnnotationPresenter annotationPresenter;
    private final HoverInformationProvider hoverInformationProvider;
    private final CompletionProposalPresenter proposalPresenter;
    private final SearchProvider searchProvider;
    private final NavigationProvider navigationProvider;
    private final EditorOpener editorOpener;
    private final BehaviorContributor behaviorContributor;
    @Inject
    private EventBus eventBus;
    private ContentAssistant contentAssistant;
    private SetProperty<Feature> featureSet = new SimpleSetProperty((Object)this, "featureSet", FXCollections.observableSet((Object[])new Feature[0]));
    private final ThreadSynchronize threadSynchronize;
    private final IContextInformationValidator contextInformationValidator;
    private final AppMemento appMemento;
    private static final String KEY_HOVER_WINDOW_WIDTH = DefaultSourceViewerConfiguration.class.getName() + ".hoverWindowWidth";
    private static final String KEY_HOVER_WINDOW_HEIGHT = DefaultSourceViewerConfiguration.class.getName() + ".hoverWindowHeight";
    private static final String KEY_PROPOSAL_WINDOW_WIDTH = DefaultSourceViewerConfiguration.class.getName() + ".proposalWindowWidth";
    private static final String KEY_PROPOSAL_WINDOW_HEIGHT = DefaultSourceViewerConfiguration.class.getName() + ".proposalWindowHeight";
    @Inject
    private IDocument document;

    @Inject
    public DefaultSourceViewerConfiguration(ThreadSynchronize threadSynchronize, Input<?> input, PresentationReconciler reconciler, AppMemento appMemento, @org.eclipse.e4.core.di.annotations.Optional ProposalComputer proposalComputer, @org.eclipse.e4.core.di.annotations.Optional IAnnotationModel annotationModel, @org.eclipse.e4.core.di.annotations.Optional AnnotationPresenter annotationPresenter, @org.eclipse.e4.core.di.annotations.Optional HoverInformationProvider hoverInformationProvider, @org.eclipse.e4.core.di.annotations.Optional CompletionProposalPresenter proposalPresenter, @org.eclipse.e4.core.di.annotations.Optional SearchProvider searchProvider, @org.eclipse.e4.core.di.annotations.Optional NavigationProvider navigationProvider, @org.eclipse.e4.core.di.annotations.Optional EditorOpener editorOpener, @org.eclipse.e4.core.di.annotations.Optional BehaviorContributor behaviorContributor, @org.eclipse.e4.core.di.annotations.Optional IContextInformationValidator contextInformationValidator) {
        this.threadSynchronize = threadSynchronize;
        this.contextInformationValidator = contextInformationValidator;
        this.input = input;
        this.hoverInformationProvider = hoverInformationProvider;
        this.reconciler = reconciler;
        this.proposalComputer = proposalComputer;
        this.annotationModel = annotationModel;
        this.proposalPresenter = proposalPresenter == null ? DefaultProposal::new : proposalPresenter;
        this.annotationPresenter = annotationPresenter;
        this.searchProvider = searchProvider;
        this.navigationProvider = navigationProvider;
        this.editorOpener = editorOpener;
        this.behaviorContributor = behaviorContributor;
        this.appMemento = appMemento;
    }

    @Inject
    public void setFeatureSet(@Preference(key="editorFeatures", nodePath="org.eclipse.fx.code.editor") Set<Feature> featureSet) {
        this.featureSet.clear();
        if (featureSet != null) {
            this.featureSet.addAll(featureSet);
        } else {
            this.featureSet.add((Object)Feature.SHOW_LINE_NUMBERS);
        }
    }

    private Range<Integer> convertRegion(IRegion region) {
        return Range.closed((Comparable)Integer.valueOf(region.getOffset()), (Comparable)Integer.valueOf(region.getOffset() + region.getLength()));
    }

    private StyledTextArea.QuickLink convertNavigationTarget(final NavigationTarget target) {
        return new StyledTextArea.CustomQuickLink(){

            public String getLabel() {
                return "need some label here!";
            }

            public Runnable getAction() {
                return () -> {
                    DefaultSourceViewerConfiguration.this.editorOpener.openEditor(target.getFile().toString());
                    DefaultSourceViewerConfiguration.this.eventBus.publish(Constants.TOPIC_SELECT_SOURCE, (Object)new SourceSelection(target.getFile().toString(), target.getRegion()), true);
                };
            }

            public String toString() {
                return "CustombQuickLink in " + target.getFile() + " @ " + String.valueOf(target.getRegion());
            }
        };
    }

    private StyledTextArea.QuickLinkable convertNavigationRegion(final NavigationRegion region) {
        return new StyledTextArea.QuickLinkable(){

            public Range<Integer> getRegion() {
                return DefaultSourceViewerConfiguration.this.convertRegion(region.getRegion());
            }

            public List<StyledTextArea.QuickLink> getLinks() {
                return region.getTargets().stream().map(arg_0 -> DefaultSourceViewerConfiguration.access$0(DefaultSourceViewerConfiguration.this, arg_0)).collect(Collectors.toList());
            }
        };
    }

    public Function<Integer, Optional<StyledTextArea.QuickLinkable>> getQuicklinkCallback() {
        if (this.navigationProvider != null) {
            return offset -> {
                try {
                    return ((Optional)this.navigationProvider.getNavigationRegion(offset.intValue()).get(400L, TimeUnit.MILLISECONDS)).map(this::convertNavigationRegion);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            };
        }
        return super.getQuicklinkCallback();
    }

    public SetProperty<Feature> getFeatures() {
        return this.featureSet;
    }

    public String getStyleclassName() {
        return "source-viewer";
    }

    public final IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return this.reconciler;
    }

    public IContentAssistant getContentAssist() {
        if (this.proposalComputer != null) {
            if (this.contentAssistant == null) {
                this.contentAssistant = new ContentAssistant(this.contextInformationValidator, this.threadSynchronize, this::computeProposals);
                this.contentAssistant.configureWindowSize(this::getProposalWindowSize, this::storeProposalWindowSize);
            }
            return this.contentAssistant;
        }
        return super.getContentAssist();
    }

    List<ICompletionProposal> computeProposals(ContentAssistContextData data) {
        try {
            return ((List)this.proposalComputer.compute().get()).stream().map(this.proposalPresenter::createProposal).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public AnnotationPresenter getAnnotationPresenter() {
        return this.annotationPresenter;
    }

    public Set<HoverInfo> getDocumentHoverInfo(IDocument document, int offset) {
        if (this.hoverInformationProvider != null) {
            return this.hoverInformationProvider.getDocumentHoverProvider().getHoverInfo(document, offset);
        }
        return super.getDocumentHoverInfo(document, offset);
    }

    public Set<HoverInfo> getAnnotationHoverInfo(Annotation annotation) {
        if (this.hoverInformationProvider != null) {
            return this.hoverInformationProvider.getAnnotationHoverProviders().stream().filter(p -> p.isApplicable(annotation.getClass())).map(p -> p.getHoverInfo(annotation)).collect(Collectors.toSet());
        }
        return super.getAnnotationHoverInfo(annotation);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, final String contentType) {
        if (this.hoverInformationProvider != null) {
            return new ITextHover(){

                public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                    return DefaultSourceViewerConfiguration.this.hoverInformationProvider.getHoverRegion(contentType, offset);
                }

                public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                    CharSequence information = DefaultSourceViewerConfiguration.this.hoverInformationProvider.getHoverInformation(contentType, hoverRegion);
                    return information == null ? null : information.toString();
                }
            };
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    public TriggerActionMapping getOverrideMapping() {
        if (this.behaviorContributor != null) {
            final TriggerActionMapping x = new TriggerActionMapping();
            this.behaviorContributor.initializeMapping(new BehaviorContributor.MappingRegistry(){

                public void map(String combo, TextEditAction action) {
                    x.map(combo, action);
                }

                public void map(char typedChar, TextEditAction action) {
                    x.map(typedChar, action);
                }

                public void mapConditional(String conditionId, Supplier<Boolean> condition, String combo, TextEditAction action) {
                    x.mapConditional(conditionId, condition, combo, action);
                }

                public void mapConditional(String conditionId, Supplier<Boolean> condition, char typedChar, TextEditAction action) {
                    x.mapConditional(conditionId, condition, typedChar, action);
                }
            });
            x.subscribe((e, c) -> this.behaviorContributor.handle(e));
            return x;
        }
        return super.getOverrideMapping();
    }

    public Point2D getHoverWindowSize() {
        if (this.appMemento == null) {
            return super.getHoverWindowSize();
        }
        double width = this.appMemento.get(KEY_HOVER_WINDOW_WIDTH, 600.0);
        double height = this.appMemento.get(KEY_HOVER_WINDOW_HEIGHT, 400.0);
        return new Point2D(width, height);
    }

    public void storeHoverWindowSize(Point2D size) {
        if (this.appMemento != null) {
            this.appMemento.put(KEY_HOVER_WINDOW_WIDTH, size.getX());
            this.appMemento.put(KEY_HOVER_WINDOW_HEIGHT, size.getY());
        }
    }

    public Point2D getProposalWindowSize() {
        if (this.appMemento == null) {
            return super.getProposalWindowSize();
        }
        double width = this.appMemento.get(KEY_PROPOSAL_WINDOW_WIDTH, 600.0);
        double height = this.appMemento.get(KEY_PROPOSAL_WINDOW_HEIGHT, 400.0);
        return new Point2D(width, height);
    }

    public void storeProposalWindowSize(Point2D size) {
        if (this.appMemento != null) {
            this.appMemento.put(KEY_PROPOSAL_WINDOW_WIDTH, size.getX());
            this.appMemento.put(KEY_PROPOSAL_WINDOW_HEIGHT, size.getY());
        }
    }

    static /* synthetic */ StyledTextArea.QuickLink access$0(DefaultSourceViewerConfiguration defaultSourceViewerConfiguration, NavigationTarget navigationTarget) {
        return defaultSourceViewerConfiguration.convertNavigationTarget(navigationTarget);
    }

    static class DefaultProposal
    implements ICompletionProposal {
        private final CompletionProposal proposal;

        public DefaultProposal(CompletionProposal proposal) {
            this.proposal = proposal;
        }

        public Node getContentNode() {
            CharSequence label = this.proposal.getLabel();
            if (label instanceof StyledString) {
                return Util.toNode((StyledString)((StyledString)label));
            }
            return new Label(label != null ? label.toString() : "<unknown>");
        }

        public Node getGraphic() {
            return null;
        }

        public void apply(IDocument document) {
            this.proposal.apply(document);
        }

        public TextSelection getSelection(IDocument document) {
            CompletionProposal.TextSelection selection = this.proposal.getSelection(document);
            return selection == null ? TextSelection.EMPTY : new TextSelection(selection.offset, selection.length);
        }

        public IContextInformation getContextInformation() {
            return new IContextInformation(){

                public String getInformationDisplayString() {
                    return null;
                }

                public Node getGraphic() {
                    return null;
                }

                public int getContextInformationPosition() {
                    return 0;
                }

                public String getContextDisplayString() {
                    return null;
                }
            };
        }

        public String getHoverInfo() {
            return null;
        }
    }
}

