/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.VariableDeclBlock;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.EventInState;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.MapRWContext;
import org.eclipse.comma.expressions.expression.QUANTIFIER;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.expressions.utilities.ExpressionsUtilities;
import org.eclipse.comma.monitoring.generator.ActionsJavaGenerator;
import org.eclipse.comma.monitoring.generator.CommaScope;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractBehaviorGenerator
extends ActionsJavaGenerator {
    protected List<ExpressionQuantifier> quantifiersInMachines;

    @Override
    public CommaScope getCommaScope(EObject o) {
        EObject container = o.eContainer();
        while (!this.isVariableScope(container)) {
            container = container.eContainer();
        }
        if (container instanceof VariableDeclBlock) {
            return CommaScope.GLOBAL;
        }
        if (container instanceof ExpressionQuantifier || container instanceof MapRWContext) {
            return CommaScope.QUANTIFIER;
        }
        return CommaScope.TRANSITION;
    }

    public boolean isVariableScope(EObject o) {
        return o instanceof VariableDeclBlock || o instanceof Transition || o instanceof ExpressionQuantifier || o instanceof MapRWContext || o instanceof EventInState || o instanceof ActionWithVars;
    }

    public List<ExpressionQuantifier> getQuantifiersInContainer(EObject cont) {
        return EcoreUtil2.getAllContentsOfType((EObject)cont, ExpressionQuantifier.class);
    }

    public List<ExpressionQuantifier> getQuantifiersInStateMachines(AbstractBehavior behavior, List<StateMachine> machines) {
        ArrayList<ExpressionQuantifier> result = new ArrayList<ExpressionQuantifier>();
        for (StateMachine m : machines) {
            result.addAll(this.getQuantifiersInContainer((EObject)m));
        }
        EList _initActions = behavior.getInitActions();
        for (Action ia : _initActions) {
            result.addAll(this.getQuantifiersInContainer((EObject)ia));
        }
        return result;
    }

    public Iterable<Variable> filterQuantifierVariables(ExpressionQuantifier quantifier) {
        Functions.Function1 _function = p -> {
            EObject _eContainer = p.eContainer();
            return !(_eContainer instanceof VariableDeclBlock);
        };
        return IterableExtensions.filter((Iterable)ExpressionsUtilities.getReferredVariablesInQuantifier((ExpressionQuantifier)quantifier), (Functions.Function1)_function);
    }

    public CharSequence generateQuantifierMethod(ExpressionQuantifier quantifier, int index) {
        StringConcatenation _xblockexpression = null;
        Iterable<Variable> parameters = this.filterQuantifierVariables(quantifier);
        CharSequence returnType = this.quantifierType(quantifier);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        _builder.append((Object)returnType);
        _builder.append(" evalQuantifier");
        _builder.append((Object)index);
        _builder.append("(");
        boolean _hasElements = false;
        for (Variable p : parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _javaType = this.toJavaType((EObject)p.getType());
            _builder.append((Object)_javaType);
            _builder.append(" ");
            CommaScope _commaScope = this.getCommaScope((EObject)p);
            boolean _equals = Objects.equal((Object)((Object)_commaScope), (Object)((Object)CommaScope.TRANSITION));
            if (_equals) {
                _builder.append("commaTVar_");
            } else {
                _builder.append("commaQVar_");
            }
            String _name = p.getName();
            _builder.append(_name);
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        QUANTIFIER _quantifier = quantifier.getQuantifier();
        boolean _equals_1 = Objects.equal((Object)_quantifier, (Object)QUANTIFIER.EXISTS);
        if (_equals_1) {
            _builder.append("\t");
            CharSequence _generateQuantifierBodyForExists = this.generateQuantifierBodyForExists(quantifier);
            _builder.append((Object)_generateQuantifierBodyForExists, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            QUANTIFIER _quantifier_1 = quantifier.getQuantifier();
            boolean _equals_2 = Objects.equal((Object)_quantifier_1, (Object)QUANTIFIER.DELETE);
            if (_equals_2) {
                _builder.append("\t");
                CharSequence _generateQuantifierBodyForDelete = this.generateQuantifierBodyForDelete(quantifier);
                _builder.append((Object)_generateQuantifierBodyForDelete, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                CharSequence _generateQuantifierBodyForForAll = this.generateQuantifierBodyForForAll(quantifier);
                _builder.append((Object)_generateQuantifierBodyForForAll, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}\t");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence quantifierType(ExpressionQuantifier exp) {
        StringConcatenation _xifexpression = null;
        QUANTIFIER _quantifier = exp.getQuantifier();
        boolean _equals = Objects.equal((Object)_quantifier, (Object)QUANTIFIER.DELETE);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("CVector<");
            CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)exp.getIterator().getType());
            _builder.append((Object)_javaReferenceType);
            _builder.append(">");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("boolean");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public CharSequence generateQuantifierBodyForExists(ExpressionQuantifier quantifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CVector<");
        CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaReferenceType);
        _builder.append("> commaCollection = ");
        CharSequence _generateExpression = this.generateExpression(quantifier.getCollection());
        _builder.append((Object)_generateExpression);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("for(");
        CharSequence _javaType = this.toJavaType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaType);
        _builder.append(" ");
        _builder.append("commaQVar_");
        String _name = quantifier.getIterator().getName();
        _builder.append(_name);
        _builder.append(" : commaCollection.getElements()){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(");
        CharSequence _generateExpression_1 = this.generateExpression(quantifier.getCondition());
        _builder.append((Object)_generateExpression_1, "\t");
        _builder.append(") return true;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return false;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateQuantifierBodyForForAll(ExpressionQuantifier quantifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CVector<");
        CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaReferenceType);
        _builder.append("> commaCollection = ");
        CharSequence _generateExpression = this.generateExpression(quantifier.getCollection());
        _builder.append((Object)_generateExpression);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("for(");
        CharSequence _javaType = this.toJavaType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaType);
        _builder.append(" ");
        _builder.append("commaQVar_");
        String _name = quantifier.getIterator().getName();
        _builder.append(_name);
        _builder.append(" : commaCollection.getElements()){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(! ");
        CharSequence _generateExpression_1 = this.generateExpression(quantifier.getCondition());
        _builder.append((Object)_generateExpression_1, "\t");
        _builder.append(") return false;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return true;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateQuantifierBodyForDelete(ExpressionQuantifier quantifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CVector<");
        CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaReferenceType);
        _builder.append("> result = new CVector<");
        CharSequence _javaReferenceType_1 = this.toJavaReferenceType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaReferenceType_1);
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("CVector<");
        CharSequence _javaReferenceType_2 = this.toJavaReferenceType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaReferenceType_2);
        _builder.append("> commaCollection = ");
        CharSequence _generateExpression = this.generateExpression(quantifier.getCollection());
        _builder.append((Object)_generateExpression);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("for(");
        CharSequence _javaType = this.toJavaType((EObject)quantifier.getIterator().getType());
        _builder.append((Object)_javaType);
        _builder.append(" ");
        _builder.append("commaQVar_");
        String _name = quantifier.getIterator().getName();
        _builder.append(_name);
        _builder.append(" : commaCollection.getElements()){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(!");
        CharSequence _generateExpression_1 = this.generateExpression(quantifier.getCondition());
        _builder.append((Object)_generateExpression_1, "\t");
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("result.getElements().add(");
        _builder.append("commaQVar_", "\t\t");
        String _name_1 = quantifier.getIterator().getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return result;");
        _builder.newLine();
        return _builder;
    }

    public Signature getInterface(TriggeredTransition t) {
        Signature _xifexpression = null;
        if (t != null) {
            EObject _eContainer = t.getTrigger().eContainer();
            _xifexpression = (Signature)_eContainer;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected CharSequence _generateExpression(ExpressionQuantifier expr) {
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        Iterable<Variable> parameters = this.filterQuantifierVariables(expr);
        StringConcatenation _builder = new StringConcatenation();
        CommaScope _commaScope = this.getCommaScope((EObject)expr);
        boolean bl = _notEquals = !Objects.equal((Object)((Object)_commaScope), (Object)((Object)CommaScope.TRANSITION));
        if (_notEquals) {
            _builder.append("this.");
        } else {
            _builder.append("stateOfDecisionClass.");
        }
        _builder.append("evalQuantifier");
        int _indexOf = this.quantifiersInMachines.indexOf(expr);
        _builder.append((Object)_indexOf);
        _builder.append("(");
        boolean _hasElements = false;
        for (Variable p : parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CommaScope _commaScope_1 = this.getCommaScope((EObject)p);
            boolean _equals = Objects.equal((Object)((Object)_commaScope_1), (Object)((Object)CommaScope.QUANTIFIER));
            if (_equals) {
                _builder.append("commaQVar_");
            } else {
                _builder.append("commaTVar_");
            }
            String _name = p.getName();
            _builder.append(_name);
        }
        _builder.append(")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence generateExpression(Expression expr) {
        if (expr instanceof ExpressionAddition) {
            return this._generateExpression((ExpressionAddition)expr);
        }
        if (expr instanceof ExpressionAnd) {
            return this._generateExpression((ExpressionAnd)expr);
        }
        if (expr instanceof ExpressionBracket) {
            return this._generateExpression((ExpressionBracket)expr);
        }
        if (expr instanceof ExpressionDivision) {
            return this._generateExpression((ExpressionDivision)expr);
        }
        if (expr instanceof ExpressionEqual) {
            return this._generateExpression((ExpressionEqual)expr);
        }
        if (expr instanceof ExpressionGeq) {
            return this._generateExpression((ExpressionGeq)expr);
        }
        if (expr instanceof ExpressionGreater) {
            return this._generateExpression((ExpressionGreater)expr);
        }
        if (expr instanceof ExpressionLeq) {
            return this._generateExpression((ExpressionLeq)expr);
        }
        if (expr instanceof ExpressionLess) {
            return this._generateExpression((ExpressionLess)expr);
        }
        if (expr instanceof ExpressionMaximum) {
            return this._generateExpression((ExpressionMaximum)expr);
        }
        if (expr instanceof ExpressionMinimum) {
            return this._generateExpression((ExpressionMinimum)expr);
        }
        if (expr instanceof ExpressionMinus) {
            return this._generateExpression((ExpressionMinus)expr);
        }
        if (expr instanceof ExpressionModulo) {
            return this._generateExpression((ExpressionModulo)expr);
        }
        if (expr instanceof ExpressionMultiply) {
            return this._generateExpression((ExpressionMultiply)expr);
        }
        if (expr instanceof ExpressionNEqual) {
            return this._generateExpression((ExpressionNEqual)expr);
        }
        if (expr instanceof ExpressionNot) {
            return this._generateExpression((ExpressionNot)expr);
        }
        if (expr instanceof ExpressionOr) {
            return this._generateExpression((ExpressionOr)expr);
        }
        if (expr instanceof ExpressionPlus) {
            return this._generateExpression((ExpressionPlus)expr);
        }
        if (expr instanceof ExpressionPower) {
            return this._generateExpression((ExpressionPower)expr);
        }
        if (expr instanceof ExpressionSubtraction) {
            return this._generateExpression((ExpressionSubtraction)expr);
        }
        if (expr instanceof ExpressionAny) {
            return this._generateExpression((ExpressionAny)expr);
        }
        if (expr instanceof ExpressionBulkData) {
            return this._generateExpression((ExpressionBulkData)expr);
        }
        if (expr instanceof ExpressionConstantBool) {
            return this._generateExpression((ExpressionConstantBool)expr);
        }
        if (expr instanceof ExpressionConstantInt) {
            return this._generateExpression((ExpressionConstantInt)expr);
        }
        if (expr instanceof ExpressionConstantReal) {
            return this._generateExpression((ExpressionConstantReal)expr);
        }
        if (expr instanceof ExpressionConstantString) {
            return this._generateExpression((ExpressionConstantString)expr);
        }
        if (expr instanceof ExpressionEnumLiteral) {
            return this._generateExpression((ExpressionEnumLiteral)expr);
        }
        if (expr instanceof ExpressionFunctionCall) {
            return this._generateExpression((ExpressionFunctionCall)expr);
        }
        if (expr instanceof ExpressionMap) {
            return this._generateExpression((ExpressionMap)expr);
        }
        if (expr instanceof ExpressionMapRW) {
            return this._generateExpression((ExpressionMapRW)expr);
        }
        if (expr instanceof ExpressionQuantifier) {
            return this._generateExpression((ExpressionQuantifier)expr);
        }
        if (expr instanceof ExpressionRecord) {
            return this._generateExpression((ExpressionRecord)expr);
        }
        if (expr instanceof ExpressionRecordAccess) {
            return this._generateExpression((ExpressionRecordAccess)expr);
        }
        if (expr instanceof ExpressionVariable) {
            return this._generateExpression((ExpressionVariable)expr);
        }
        if (expr instanceof ExpressionVector) {
            return this._generateExpression((ExpressionVector)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

