/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.PolyglotBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.Pair;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;

public final class PolyglotBuiltins
extends JSBuiltinsContainer.SwitchEnum<Polyglot> {
    public static final JSBuiltinsContainer BUILTINS = new PolyglotBuiltins();
    public static final JSBuiltinsContainer INTERNAL_BUILTINS = new PolyglotInternalBuiltins();

    protected PolyglotBuiltins() {
        super("Polyglot", Polyglot.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Polyglot builtinEnum) {
        switch (builtinEnum) {
            case export: {
                return PolyglotBuiltinsFactory.PolyglotExportNodeGen.create(context, builtin, PolyglotBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case import_: {
                return PolyglotBuiltinsFactory.PolyglotImportNodeGen.create(context, builtin, PolyglotBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case eval: {
                return PolyglotBuiltinsFactory.PolyglotEvalNodeGen.create(context, builtin, PolyglotBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    static abstract class PolyglotToPolyglotValueNode
    extends JSBuiltinNode {
        @Node.Child
        private ExportValueNode exportValueNode = ExportValueNode.create();

        PolyglotToPolyglotValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object execute(Object value) {
            return this.exportValueNode.execute(value);
        }
    }

    static abstract class PolyglotToJSValueNode
    extends JSBuiltinNode {
        PolyglotToJSValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final Object toJSValue(TruffleObject obj, @CachedLibrary(limit="1") InteropLibrary interop) {
            return JSInteropUtil.toPrimitiveOrDefault(obj, obj, interop, this);
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected static Object toJSValue(Object obj) {
            return obj;
        }
    }

    static abstract class PolyglotCreateForeignDynamicObjectNode
    extends JSBuiltinNode {
        private static Class<?> testMapClass;

        PolyglotCreateForeignDynamicObjectNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object createForeignDynamicObject() {
            if (!JSConfig.SubstrateVM) {
                try {
                    if (testMapClass == null) {
                        testMapClass = Class.forName("com.oracle.truffle.js.test.polyglot.ForeignDynamicObject");
                    }
                    Method createNew = testMapClass.getMethod("createNew", new Class[0]);
                    return createNew.invoke(null, new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw Errors.createTypeError("cannot test with ForeignDynamicObject: " + e.getMessage());
                }
            }
            return Undefined.instance;
        }
    }

    static abstract class PolyglotCreateForeignObjectNode
    extends JSBuiltinNode {
        private static Class<?> testMapClass;

        PolyglotCreateForeignObjectNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object createForeignObject() {
            if (!JSConfig.SubstrateVM) {
                try {
                    if (testMapClass == null) {
                        testMapClass = Class.forName("com.oracle.truffle.js.test.polyglot.ForeignTestMap");
                    }
                    return this.getContext().getRealm().getEnv().asGuestValue(testMapClass.newInstance());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw Errors.createTypeError("cannot test with ForeignTestMap: " + e.getMessage());
                }
            }
            return Undefined.instance;
        }
    }

    static abstract class PolyglotIsInstantiableNode
    extends JSBuiltinNode {
        PolyglotIsInstantiableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean isInstantiable(TruffleObject obj, @CachedLibrary(limit="3") InteropLibrary interop) {
            return interop.isInstantiable((Object)obj);
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    static abstract class PolyglotKeysNode
    extends JSBuiltinNode {
        PolyglotKeysNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object keys(TruffleObject obj) {
            return JSArray.createConstantObjectArray(this.getContext(), JSInteropUtil.keys(obj).toArray());
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj) {
            throw Errors.createTypeErrorNotATruffleObject("keys");
        }
    }

    static abstract class PolyglotHasKeysNode
    extends JSBuiltinNode {
        PolyglotHasKeysNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean hasKeys(TruffleObject obj, @CachedLibrary(limit="3") InteropLibrary interop) {
            return interop.hasMembers((Object)obj);
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj) {
            return false;
        }
    }

    static abstract class PolyglotEvalFileNode
    extends PolyglotEvalBaseNode {
        PolyglotEvalFileNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"language.equals(cachedLanguage)"}, limit="1")
        protected Object evalFileCachedLanguage(String language, String file, @Cached(value="language") String cachedLanguage, @Cached(value="getLanguageIdAndMimeType(language)") Pair<String, String> languagePair, @Cached @Cached.Shared(value="callNode") IndirectCallNode callNode) {
            return callNode.call(this.evalFileIntl(file, languagePair.getFirst(), languagePair.getSecond()), new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"evalFileCachedLanguage"})
        protected Object evalFileString(String language, String file, @Cached @Cached.Shared(value="callNode") IndirectCallNode callNode) {
            Pair<String, String> pair = this.getLanguageIdAndMimeType(language);
            return callNode.call(this.evalFileIntl(file, pair.getFirst(), pair.getSecond()), new Object[0]);
        }

        private CallTarget evalFileIntl(String fileName, String languageId, String mimeType) {
            Source source;
            CompilerAsserts.neverPartOfCompilation();
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            try {
                source = Source.newBuilder((String)languageId, (TruffleFile)env.getPublicTruffleFile(fileName)).mimeType(mimeType).build();
            }
            catch (AccessDeniedException e) {
                throw Errors.createError("Cannot evaluate file " + fileName + ": permission denied");
            }
            catch (NoSuchFileException e) {
                throw Errors.createError("Cannot evaluate file " + fileName + ": no such file");
            }
            catch (IOException | SecurityException e) {
                throw Errors.createError("Cannot evaluate file: " + e.getMessage());
            }
            try {
                return env.parsePublic(source, new String[0]);
            }
            catch (IllegalStateException ex) {
                throw Errors.createErrorFromException(ex);
            }
        }

        @Specialization(guards={"!isString(languageId) || !isString(fileName)"})
        protected Object eval(Object languageId, Object fileName) {
            throw Errors.createTypeError("Expected arguments: (String languageId, String fileName)");
        }
    }

    static abstract class PolyglotEvalNode
    extends PolyglotEvalBaseNode {
        PolyglotEvalNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"language.equals(cachedLanguage)"}, limit="1")
        protected Object evalCachedLanguage(String language, String source, @Cached(value="language") String cachedLanguage, @Cached(value="getLanguageIdAndMimeType(language)") Pair<String, String> languagePair, @Cached @Cached.Shared(value="callNode") IndirectCallNode callNode) {
            return callNode.call(this.evalStringIntl(source, languagePair.getFirst(), languagePair.getSecond()), new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"evalCachedLanguage"})
        protected Object evalString(String language, String source, @Cached @Cached.Shared(value="callNode") IndirectCallNode callNode) {
            Pair<String, String> pair = this.getLanguageIdAndMimeType(language);
            return callNode.call(this.evalStringIntl(source, pair.getFirst(), pair.getSecond()), new Object[0]);
        }

        private CallTarget evalStringIntl(String sourceText, String languageId, String mimeType) {
            CompilerAsserts.neverPartOfCompilation();
            this.getContext().checkEvalAllowed();
            Source source = Source.newBuilder((String)languageId, (CharSequence)sourceText, (String)"<eval>").mimeType(mimeType).build();
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            try {
                return env.parsePublic(source, new String[0]);
            }
            catch (IllegalStateException ex) {
                throw Errors.createErrorFromException(ex);
            }
        }

        @Specialization(guards={"!isString(languageId) || !isString(source)"})
        protected Object eval(Object languageId, Object source) {
            throw Errors.createTypeError("Expected arguments: (String languageId, String sourceCode)");
        }
    }

    static abstract class PolyglotEvalBaseNode
    extends JSBuiltinNode {
        protected final ConditionProfile isValid = ConditionProfile.createBinaryProfile();

        PolyglotEvalBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Pair<String, String> getLanguageIdAndMimeType(String languageIdOrMimeType) {
            String language;
            String languageId = languageIdOrMimeType;
            String mimeType = null;
            if (languageIdOrMimeType.indexOf(47) >= 0 && (language = Source.findLanguage((String)languageIdOrMimeType)) != null) {
                languageId = language;
                mimeType = languageIdOrMimeType;
            }
            return new Pair<String, Object>(languageId, mimeType);
        }
    }

    static abstract class PolyglotGetSizeNode
    extends JSBuiltinNode {
        PolyglotGetSizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getSize(TruffleObject obj, @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                return interop.getArraySize((Object)obj);
            }
            catch (UnsupportedMessageException e) {
                return Null.instance;
            }
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj) {
            throw Errors.createTypeErrorNotATruffleObject("getSize");
        }
    }

    static abstract class PolyglotConstructNode
    extends JSBuiltinNode {
        PolyglotConstructNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doNew(TruffleObject obj, Object[] arguments, @Cached ExportValueNode exportValue, @CachedLibrary(limit="3") InteropLibrary interop) {
            Object target = exportValue.execute(obj);
            Object[] convertedArgs = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                convertedArgs[i] = exportValue.execute(arguments[i]);
            }
            try {
                return interop.instantiate(target, convertedArgs);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "instantiate", this);
            }
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object[] arguments) {
            throw Errors.createTypeErrorNotATruffleObject("construct");
        }
    }

    static abstract class PolyglotExecuteNode
    extends JSBuiltinNode {
        PolyglotExecuteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object execute(TruffleObject obj, Object[] arguments, @Cached ExportValueNode exportValue, @CachedLibrary(limit="3") InteropLibrary interop) {
            Object target = exportValue.execute(obj);
            Object[] convertedArgs = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                convertedArgs[i] = exportValue.execute(arguments[i]);
            }
            try {
                return interop.execute(target, convertedArgs);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "execute", this);
            }
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object[] arguments) {
            throw Errors.createTypeErrorNotATruffleObject("execute");
        }
    }

    static abstract class PolyglotUnboxValueNode
    extends JSBuiltinNode {
        PolyglotUnboxValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object truffleObject(TruffleObject obj, @CachedLibrary(limit="1") InteropLibrary interop) {
            Object unboxed = JSInteropUtil.toPrimitiveOrDefault(obj, obj, interop, this);
            if (unboxed == obj) {
                throw Errors.createTypeErrorNotATruffleObject("unbox");
            }
            return unboxed;
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected Object primitive(Object obj) {
            return obj;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected boolean unsupported(Object obj) {
            throw Errors.createTypeErrorNotATruffleObject("unbox");
        }
    }

    static abstract class PolyglotRemoveNode
    extends JSBuiltinNode {
        PolyglotRemoveNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean member(TruffleObject obj, String name, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                interop.removeMember((Object)obj, name);
                return true;
            }
            catch (UnknownIdentifierException e) {
                return false;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "removeMember", name, this);
            }
        }

        @Specialization
        protected boolean arrayElementInt(TruffleObject obj, int index, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                interop.removeArrayElement((Object)obj, (long)index);
                return true;
            }
            catch (InvalidArrayIndexException e) {
                return false;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "removeArrayElement", index, this);
            }
        }

        @Specialization(guards={"isNumber(index)"}, replaces={"arrayElementInt"})
        protected boolean arrayElement(TruffleObject obj, Number index, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                interop.removeArrayElement((Object)obj, index.longValue());
                return true;
            }
            catch (InvalidArrayIndexException e) {
                return false;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "removeArrayElement", index, this);
            }
        }

        @Specialization(guards={"!isString(key)", "!isNumber(key)"})
        protected Object unsupportedKey(TruffleObject obj, Object key, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary keyInterop) {
            try {
                if (keyInterop.isString(key)) {
                    return this.member(obj, keyInterop.asString(key), interop);
                }
                if (keyInterop.fitsInInt(key)) {
                    return this.arrayElementInt(obj, keyInterop.asInt(key), interop);
                }
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorUnboxException(obj, (InteropException)((Object)e), this);
            }
            return Null.instance;
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object key) {
            throw Errors.createTypeErrorNotATruffleObject("remove");
        }
    }

    static abstract class PolyglotWriteNode
    extends JSBuiltinNode {
        PolyglotWriteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object member(TruffleObject obj, String name, Object value, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportValue, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            Object convertedValue = exportValue.execute(value);
            try {
                interop.writeMember((Object)obj, name, convertedValue);
                return convertedValue;
            }
            catch (UnknownIdentifierException e) {
                return Null.instance;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "writeMember", name, this);
            }
        }

        @Specialization
        protected Object arrayElementInt(TruffleObject obj, int index, Object value, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportValue, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            Object convertedValue = exportValue.execute(value);
            try {
                interop.writeArrayElement((Object)obj, (long)index, convertedValue);
                return convertedValue;
            }
            catch (InvalidArrayIndexException e) {
                return Null.instance;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "writeArrayElement", index, this);
            }
        }

        @Specialization(guards={"isNumber(index)"}, replaces={"arrayElementInt"})
        protected Object arrayElement(TruffleObject obj, Number index, Object value, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportValue, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            Object convertedValue = exportValue.execute(value);
            try {
                interop.writeArrayElement((Object)obj, index.longValue(), convertedValue);
                return convertedValue;
            }
            catch (InvalidArrayIndexException e) {
                return Null.instance;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "writeArrayElement", index, this);
            }
        }

        @Specialization(guards={"!isString(key)", "!isNumber(key)"})
        protected Object unsupportedKey(TruffleObject obj, Object key, Object value, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportValue, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary keyInterop) {
            try {
                if (keyInterop.isString(key)) {
                    return this.member(obj, keyInterop.asString(key), value, exportValue, interop);
                }
                if (keyInterop.fitsInInt(key)) {
                    return this.arrayElement(obj, keyInterop.asInt(key), value, exportValue, interop);
                }
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorUnboxException(obj, (InteropException)((Object)e), this);
            }
            return Null.instance;
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object name, Object value) {
            throw Errors.createTypeErrorNotATruffleObject("write");
        }
    }

    static abstract class PolyglotReadNode
    extends JSBuiltinNode {
        PolyglotReadNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object member(TruffleObject obj, String name, @Cached.Shared(value="importValue") @Cached(value="create()") JSForeignToJSTypeNode foreignConvert, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            return JSInteropUtil.readMemberOrDefault(obj, name, Null.instance, interop, foreignConvert, this);
        }

        @Specialization
        protected Object arrayElementInt(TruffleObject obj, int index, @Cached.Shared(value="importValue") @Cached(value="create()") JSForeignToJSTypeNode foreignConvert, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            return JSInteropUtil.readArrayElementOrDefault(obj, index, Null.instance, interop, foreignConvert, this);
        }

        @Specialization(guards={"isNumber(index)"}, replaces={"arrayElementInt"})
        protected Object arrayElement(TruffleObject obj, Number index, @Cached.Shared(value="importValue") @Cached(value="create()") JSForeignToJSTypeNode foreignConvert, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            return JSInteropUtil.readArrayElementOrDefault(obj, index.longValue(), Null.instance, interop, foreignConvert, this);
        }

        @Specialization(guards={"!isString(key)", "!isNumber(key)"})
        protected Object unsupportedKey(TruffleObject obj, Object key, @Cached.Shared(value="importValue") @Cached(value="create()") JSForeignToJSTypeNode foreignConvert, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary keyInterop) {
            try {
                if (keyInterop.isString(key)) {
                    return this.member(obj, keyInterop.asString(key), foreignConvert, interop);
                }
                if (keyInterop.fitsInInt(key)) {
                    return this.arrayElement(obj, keyInterop.asInt(key), foreignConvert, interop);
                }
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorUnboxException(obj, (InteropException)((Object)e), this);
            }
            return Null.instance;
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object name) {
            throw Errors.createTypeErrorNotATruffleObject("read");
        }
    }

    static abstract class PolyglotHasSizeNode
    extends JSBuiltinNode {
        PolyglotHasSizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean truffleObject(TruffleObject obj, @CachedLibrary(limit="3") InteropLibrary interop) {
            return interop.hasArrayElements((Object)obj);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected boolean unsupported(Object obj) {
            return false;
        }
    }

    static abstract class PolyglotIsNullNode
    extends JSBuiltinNode {
        PolyglotIsNullNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean truffleObject(TruffleObject obj, @CachedLibrary(limit="3") InteropLibrary interop) {
            return interop.isNull((Object)obj);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected static boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    static abstract class PolyglotIsBoxedPrimitiveNode
    extends JSBuiltinNode {
        PolyglotIsBoxedPrimitiveNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(limit="3")
        protected static boolean truffleObject(TruffleObject obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            return interop.isBoolean((Object)obj) || interop.isString((Object)obj) || interop.isNumber((Object)obj);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected static boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    static abstract class PolyglotIsExecutableNode
    extends JSBuiltinNode {
        PolyglotIsExecutableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean truffleObject(TruffleObject obj, @CachedLibrary(limit="3") InteropLibrary interop) {
            return interop.isExecutable((Object)obj);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected static boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    static abstract class PolyglotImportNode
    extends JSBuiltinNode {
        PolyglotImportNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doString(String identifier, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop, @Cached.Shared(value="importValue") @Cached JSForeignToJSTypeNode importValueNode) {
            Object polyglotBindings;
            try {
                polyglotBindings = this.getContext().getRealm().getEnv().getPolyglotBindings();
            }
            catch (SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
            try {
                return importValueNode.executeWithTarget(interop.readMember(polyglotBindings, identifier));
            }
            catch (UnknownIdentifierException e) {
                return Undefined.instance;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(polyglotBindings, (InteropException)((Object)e), "readMember", identifier, this);
            }
        }

        @Specialization(guards={"!isString(identifier)"})
        protected Object doMaybeUnbox(TruffleObject identifier, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop, @Cached.Shared(value="importValue") @Cached JSForeignToJSTypeNode importValueNode) {
            if (interop.isString((Object)identifier)) {
                String unboxed;
                try {
                    unboxed = interop.asString((Object)identifier);
                }
                catch (UnsupportedMessageException e) {
                    throw Errors.createTypeErrorUnboxException(identifier, (InteropException)((Object)e), this);
                }
                return this.doString(unboxed, interop, importValueNode);
            }
            return this.doInvalid(identifier);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isString(identifier)", "!isTruffleObject(identifier)"})
        protected Object doInvalid(Object identifier) {
            throw Errors.createTypeErrorInvalidIdentifier(identifier);
        }
    }

    static abstract class PolyglotExportNode
    extends JSBuiltinNode {
        @Node.Child
        private ExportValueNode exportValue = ExportValueNode.create();

        PolyglotExportNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doString(String identifier, Object value, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            Object polyglotBindings;
            try {
                polyglotBindings = this.getContext().getRealm().getEnv().getPolyglotBindings();
            }
            catch (SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
            JSInteropUtil.writeMember(polyglotBindings, identifier, value, interop, this.exportValue, this);
            return value;
        }

        @Specialization(guards={"!isString(identifier)"})
        protected Object doMaybeUnbox(TruffleObject identifier, Object value, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
            if (interop.isString((Object)identifier)) {
                String unboxed;
                try {
                    unboxed = interop.asString((Object)identifier);
                }
                catch (UnsupportedMessageException e) {
                    throw Errors.createTypeErrorUnboxException(identifier, (InteropException)((Object)e), this);
                }
                return this.doString(unboxed, value, interop);
            }
            return this.doInvalid(identifier, value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isString(identifier)"})
        protected Object doInvalid(Object identifier, Object value) {
            throw Errors.createTypeErrorInvalidIdentifier(identifier);
        }
    }

    public static final class PolyglotInternalBuiltins
    extends JSBuiltinsContainer.SwitchEnum<PolyglotInternal> {
        protected PolyglotInternalBuiltins() {
            super("Polyglot", PolyglotInternal.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, PolyglotInternal builtinEnum) {
            switch (builtinEnum) {
                case isExecutable: {
                    return PolyglotBuiltinsFactory.PolyglotIsExecutableNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case isBoxed: {
                    return PolyglotBuiltinsFactory.PolyglotIsBoxedPrimitiveNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case isNull: {
                    return PolyglotBuiltinsFactory.PolyglotIsNullNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case isInstantiable: {
                    return PolyglotBuiltinsFactory.PolyglotIsInstantiableNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case hasSize: {
                    return PolyglotBuiltinsFactory.PolyglotHasSizeNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case read: {
                    return PolyglotBuiltinsFactory.PolyglotReadNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(2).createArgumentNodes(context));
                }
                case write: {
                    return PolyglotBuiltinsFactory.PolyglotWriteNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(3).createArgumentNodes(context));
                }
                case remove: {
                    return PolyglotBuiltinsFactory.PolyglotRemoveNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(2).createArgumentNodes(context));
                }
                case unbox: {
                    return PolyglotBuiltinsFactory.PolyglotUnboxValueNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case construct: {
                    return PolyglotBuiltinsFactory.PolyglotConstructNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
                }
                case execute: {
                    return PolyglotBuiltinsFactory.PolyglotExecuteNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
                }
                case getSize: {
                    return PolyglotBuiltinsFactory.PolyglotGetSizeNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case keys: {
                    return PolyglotBuiltinsFactory.PolyglotKeysNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case toJSValue: {
                    return PolyglotBuiltinsFactory.PolyglotToJSValueNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case toPolyglotValue: {
                    return PolyglotBuiltinsFactory.PolyglotToPolyglotValueNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case hasKeys: {
                    return PolyglotBuiltinsFactory.PolyglotHasKeysNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case evalFile: {
                    return PolyglotBuiltinsFactory.PolyglotEvalFileNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(2).createArgumentNodes(context));
                }
                case createForeignObject: {
                    if (JSConfig.SubstrateVM) break;
                    return PolyglotBuiltinsFactory.PolyglotCreateForeignObjectNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(0).createArgumentNodes(context));
                }
                case createForeignDynamicObject: {
                    if (JSConfig.SubstrateVM) break;
                    return PolyglotBuiltinsFactory.PolyglotCreateForeignDynamicObjectNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(0).createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum PolyglotInternal implements BuiltinEnum<PolyglotInternal>
        {
            isExecutable(1),
            isBoxed(1),
            isNull(1),
            hasSize(1),
            read(2),
            write(3),
            unbox(1),
            construct(1),
            execute(1),
            getSize(1),
            remove(2),
            toJSValue(1),
            toPolyglotValue(1),
            keys(1),
            hasKeys(1),
            isInstantiable(1),
            evalFile(2),
            createForeignObject(0){

                @Override
                public boolean isAOTSupported() {
                    return false;
                }
            }
            ,
            createForeignDynamicObject(0){

                @Override
                public boolean isAOTSupported() {
                    return false;
                }
            };

            private final int length;

            private PolyglotInternal(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static enum Polyglot implements BuiltinEnum<Polyglot>
    {
        export(2),
        import_(1),
        eval(2);

        private final int length;

        private Polyglot(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

