/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.tregex.buffer.ByteArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.matchers.AnyMatcher;
import com.oracle.truffle.regex.tregex.matchers.BitSetMatcher;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.matchers.EmptyMatcher;
import com.oracle.truffle.regex.tregex.matchers.HybridBitSetMatcher;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.MultiBitSetMatcher;
import com.oracle.truffle.regex.tregex.matchers.ProfilingCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeListMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeTreeMatcher;
import com.oracle.truffle.regex.tregex.matchers.SingleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.SingleRangeMatcher;
import com.oracle.truffle.regex.tregex.matchers.TwoCharMatcher;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Iterator;

public class CP16BitMatchers {
    public static CharMatcher createMatcher(CodePointSet cps, CompilationBuffer compilationBuffer) {
        if (cps.matchesMinAndMax() || cps.inverseIsSameHighByte16Bit()) {
            return CP16BitMatchers.createMatcher(cps.createInverse(), compilationBuffer, true, true);
        }
        return CP16BitMatchers.createMatcher(cps, compilationBuffer, false, true);
    }

    public static int highByte(int c) {
        return c >> 8 & 0xFF;
    }

    public static int lowByte(int c) {
        return c & 0xFF;
    }

    private static CharMatcher createMatcher(CodePointSet cps, CompilationBuffer compilationBuffer, boolean inverse, boolean tryHybrid) {
        CharMatcher charMatcher;
        if (cps.numberOf16BitRanges() == 0) {
            return EmptyMatcher.create(inverse);
        }
        if (cps.matchesEverything()) {
            return AnyMatcher.create(inverse);
        }
        if (cps.matchesSingleChar()) {
            assert (cps.getMin() <= 65535);
            return SingleCharMatcher.create(inverse, cps.getMin());
        }
        if (cps.valueCountEquals(2)) {
            assert (cps.getMax() <= 65535);
            return TwoCharMatcher.create(inverse, cps.getMin(), cps.getMax());
        }
        int size = cps.numberOf16BitRanges();
        if (size == 1) {
            return SingleRangeMatcher.create(inverse, cps.getLo16(0), cps.getHi16(0));
        }
        if (CP16BitMatchers.preferRangeListMatcherOverBitSetMatcher(cps, size)) {
            return RangeListMatcher.create(inverse, CP16BitMatchers.toCharArray(cps, size));
        }
        InvertibleCharMatcher bitSetMatcher = CP16BitMatchers.convertToBitSetMatcher(cps, compilationBuffer, inverse);
        if (bitSetMatcher != null) {
            return bitSetMatcher;
        }
        if (size > 100) {
            charMatcher = MultiBitSetMatcher.fromCodePointSet(inverse, cps);
        } else if (tryHybrid) {
            charMatcher = CP16BitMatchers.createHybridMatcher(cps, compilationBuffer, inverse);
        } else if (size <= 10) {
            charMatcher = RangeListMatcher.create(inverse, CP16BitMatchers.toCharArray(cps, size));
        } else {
            assert (size <= 100);
            charMatcher = RangeTreeMatcher.fromRanges(inverse, CP16BitMatchers.toCharArray(cps, size));
        }
        return ProfilingCharMatcher.create(CP16BitMatchers.createMatcher(cps.createIntersection(Constants.BYTE_RANGE, compilationBuffer), compilationBuffer, inverse, false), charMatcher);
    }

    private static boolean preferRangeListMatcherOverBitSetMatcher(CodePointSet cps, int size) {
        return size <= 2 || cps.valueCountMax(4);
    }

    private static InvertibleCharMatcher convertToBitSetMatcher(CodePointSet cps, CompilationBuffer compilationBuffer, boolean inverse) {
        int highByte = CP16BitMatchers.highByte(cps.getMin());
        if (CP16BitMatchers.highByte(cps.getHi16(cps.size16() - 1)) != highByte) {
            return null;
        }
        CompilationFinalBitSet bs = compilationBuffer.getByteSizeBitSet();
        for (int i = 0; i < cps.numberOf16BitRanges(); ++i) {
            assert (CP16BitMatchers.highByte(cps.getLo16(i)) == highByte && CP16BitMatchers.highByte(cps.getHi16(i)) == highByte);
            bs.setRange(CP16BitMatchers.lowByte(cps.getLo16(i)), CP16BitMatchers.lowByte(cps.getHi16(i)));
        }
        return BitSetMatcher.create(inverse, highByte, bs.copy());
    }

    private static CharMatcher createHybridMatcher(CodePointSet cps, CompilationBuffer compilationBuffer, boolean inverse) {
        int size = cps.size16();
        assert (size >= 1);
        IntRangesBuffer rest = compilationBuffer.getIntRangesBuffer1();
        ByteArrayBuffer highBytes = compilationBuffer.getByteArrayBuffer();
        ObjectArrayBuffer<CompilationFinalBitSet> bitSets = compilationBuffer.getObjectBuffer1();
        int lowestOCP = 0;
        boolean lowestRangeCanBeDeleted = !CP16BitMatchers.rangeCrossesPlanes(cps, 0);
        int curPlane = CP16BitMatchers.highByte(cps.getHi16(0));
        for (int i = 0; i < size; ++i) {
            if (CP16BitMatchers.highByte(cps.getLo16(i)) != curPlane) {
                if (CP16BitMatchers.isOverBitSetConversionThreshold(i - lowestOCP)) {
                    CP16BitMatchers.addBitSet(cps, rest, highBytes, bitSets, curPlane, lowestOCP, i, lowestRangeCanBeDeleted);
                } else {
                    cps.appendRangesTo(rest, lowestOCP, i);
                }
                curPlane = CP16BitMatchers.highByte(cps.getLo16(i));
                lowestOCP = i;
                boolean bl = lowestRangeCanBeDeleted = !CP16BitMatchers.rangeCrossesPlanes(cps, i);
            }
            if (CP16BitMatchers.highByte(cps.getHi16(i)) == curPlane) continue;
            if (lowestOCP != i) {
                if (CP16BitMatchers.isOverBitSetConversionThreshold(i + 1 - lowestOCP)) {
                    CP16BitMatchers.addBitSet(cps, rest, highBytes, bitSets, curPlane, lowestOCP, i + 1, lowestRangeCanBeDeleted);
                    lowestRangeCanBeDeleted = CP16BitMatchers.highByte(cps.getHi16(i)) - CP16BitMatchers.highByte(cps.getLo16(i)) == 1;
                } else {
                    cps.appendRangesTo(rest, lowestOCP, i);
                    lowestRangeCanBeDeleted = !CP16BitMatchers.rangeCrossesPlanes(cps, i);
                }
            } else {
                lowestRangeCanBeDeleted = !CP16BitMatchers.rangeCrossesPlanes(cps, i);
            }
            curPlane = CP16BitMatchers.highByte(cps.getHi16(i));
            lowestOCP = i;
        }
        if (CP16BitMatchers.isOverBitSetConversionThreshold(size - lowestOCP)) {
            CP16BitMatchers.addBitSet(cps, rest, highBytes, bitSets, curPlane, lowestOCP, size, lowestRangeCanBeDeleted);
        } else {
            cps.appendRangesTo(rest, lowestOCP, size);
        }
        if (highBytes.length() == 0) {
            assert (rest.length() == size * 2);
            return CP16BitMatchers.createMatcher(cps, compilationBuffer, inverse, false);
        }
        CharMatcher restMatcher = CP16BitMatchers.createMatcher(CodePointSet.create(rest), compilationBuffer, false, false);
        return HybridBitSetMatcher.create(inverse, highBytes.toArray(), bitSets.toArray(new CompilationFinalBitSet[bitSets.length()]), restMatcher);
    }

    private static boolean isOverBitSetConversionThreshold(int nRanges) {
        return nRanges >= 3;
    }

    private static void addBitSet(CodePointSet ranges, IntRangesBuffer rest, ByteArrayBuffer highBytes, ObjectArrayBuffer<CompilationFinalBitSet> bitSets, int curPlane, int lowestOCP, int i, boolean lowestRangeCanBeDeleted) {
        highBytes.add((byte)curPlane);
        bitSets.add(CP16BitMatchers.convertToBitSet(ranges, curPlane, lowestOCP, i));
        if (!lowestRangeCanBeDeleted) {
            ranges.addRangeTo(rest, lowestOCP);
        }
    }

    private static boolean rangeCrossesPlanes(CodePointSet ranges, int i) {
        return CP16BitMatchers.highByte(ranges.getLo16(i)) != CP16BitMatchers.highByte(ranges.getHi16(i));
    }

    private static CompilationFinalBitSet convertToBitSet(CodePointSet ranges, int highByte, int iMinArg, int iMaxArg) {
        CompilationFinalBitSet bs;
        assert (iMaxArg - iMinArg > 1);
        int iMax = iMaxArg;
        if (CP16BitMatchers.rangeCrossesPlanes(ranges, iMaxArg - 1)) {
            bs = new CompilationFinalBitSet(255);
            --iMax;
            bs.setRange(CP16BitMatchers.lowByte(ranges.getLo16(iMaxArg - 1)), 255);
        } else {
            bs = new CompilationFinalBitSet(CP16BitMatchers.lowByte(ranges.getHi16(iMaxArg - 1)));
        }
        int iMin = iMinArg;
        if (CP16BitMatchers.rangeCrossesPlanes(ranges, iMinArg)) {
            assert (CP16BitMatchers.highByte(ranges.getHi16(iMinArg)) == highByte);
            ++iMin;
            bs.setRange(0, CP16BitMatchers.lowByte(ranges.getHi16(iMinArg)));
        }
        for (int i = iMin; i < iMax; ++i) {
            assert (CP16BitMatchers.highByte(ranges.getLo16(i)) == highByte && CP16BitMatchers.highByte(ranges.getHi16(i)) == highByte);
            bs.setRange(CP16BitMatchers.lowByte(ranges.getLo16(i)), CP16BitMatchers.lowByte(ranges.getHi16(i)));
        }
        return bs;
    }

    private static char[] toCharArray(CodePointSet cps, int size) {
        int length = size * 2;
        Iterator<Range> it = cps.iterator16Bit();
        char[] arr = new char[length];
        int i = 0;
        while (it.hasNext()) {
            Range r = it.next();
            assert (r.lo <= 65535 && r.hi <= 65535);
            arr[i] = (char)r.lo;
            arr[i + 1] = (char)r.hi;
            i += 2;
        }
        return arr;
    }

    @CompilerDirectives.TruffleBoundary
    public static String rangesToString(char[] ranges) {
        return CP16BitMatchers.rangesToString(ranges, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static String rangesToString(char[] ranges, boolean numeric) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.length; i += 2) {
            if (numeric) {
                sb.append("[").append((int)ranges[i]).append("-").append((int)ranges[i + 1]).append("]");
                continue;
            }
            sb.append(Range.toString(ranges[i], ranges[i + 1]));
        }
        return sb.toString();
    }
}

