/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.Set;

public abstract class IteratorValueNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode iterResultNode;
    @Node.Child
    private PropertyGetNode getValueNode;

    protected IteratorValueNode(JSContext context, JavaScriptNode iterResultNode) {
        this.iterResultNode = iterResultNode;
        this.getValueNode = PropertyGetNode.create("value", false, context);
    }

    public static IteratorValueNode create(JSContext context) {
        return IteratorValueNode.create(context, null);
    }

    public static IteratorValueNode create(JSContext context, JavaScriptNode iterResult) {
        return IteratorValueNodeGen.create(context, iterResult);
    }

    @Specialization
    protected Object doIteratorNext(DynamicObject iterResult) {
        return this.getValueNode.getValue(iterResult);
    }

    public abstract Object execute(DynamicObject var1);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorValueNodeGen.create(this.getValueNode.getContext(), IteratorValueNode.cloneUninitialized(this.iterResultNode, materializedTags));
    }
}

