/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.ibm.icu.text.BreakIterator;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.SegmenterPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSSegmenter;
import com.oracle.truffle.js.runtime.objects.JSObject;

public final class SegmenterPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SegmenterPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SegmenterPrototypeBuiltins();

    protected SegmenterPrototypeBuiltins() {
        super("Segmenter.prototype", SegmenterPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SegmenterPrototype builtinEnum) {
        switch (builtinEnum) {
            case resolvedOptions: {
                return SegmenterPrototypeBuiltinsFactory.JSSegmenterResolvedOptionsNodeGen.create(context, builtin, SegmenterPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case segment: {
                return SegmenterPrototypeBuiltinsFactory.JSSegmenterSegmentNodeGen.create(context, builtin, SegmenterPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static class CreateSegmentIteratorNode
    extends JavaScriptBaseNode {
        private final JSContext context;

        protected CreateSegmentIteratorNode(JSContext context) {
            this.context = context;
        }

        public static CreateSegmentIteratorNode create(JSContext context) {
            return new CreateSegmentIteratorNode(context);
        }

        public DynamicObject execute(DynamicObject segmenter, String value) {
            assert (JSSegmenter.isJSSegmenter(segmenter));
            BreakIterator icuIterator = JSSegmenter.createBreakIterator(segmenter, value);
            JSSegmenter.Granularity granularity = JSSegmenter.getGranularity(segmenter);
            return JSObject.createWithRealm(this.context, this.context.getSegmentIteratorFactory(), this.context.getRealm(), value, icuIterator, granularity, null, 0);
        }
    }

    public static abstract class JSSegmenterSegmentNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateSegmentIteratorNode createSegmentIteratorNode;

        public JSSegmenterSegmentNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createSegmentIteratorNode = CreateSegmentIteratorNode.create(context);
        }

        @Specialization(guards={"isJSSegmenter(segmenter)"})
        public Object doSegment(DynamicObject segmenter, Object value, @Cached(value="create()") JSToStringNode toStringNode) {
            return this.createSegmentIteratorNode.execute(segmenter, toStringNode.executeString(value));
        }

        @Specialization(guards={"!isJSSegmenter(bummer)"})
        public void throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorSegmenterExpected();
        }
    }

    public static abstract class JSSegmenterResolvedOptionsNode
    extends JSBuiltinNode {
        public JSSegmenterResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSSegmenter(segmenter)"})
        public Object doResolvedOptions(DynamicObject segmenter) {
            return JSSegmenter.resolvedOptions(this.getContext(), segmenter);
        }

        @Specialization(guards={"!isJSSegmenter(bummer)"})
        public void doResolvedOptions(Object bummer) {
            throw Errors.createTypeErrorSegmenterExpected();
        }
    }

    public static enum SegmenterPrototype implements BuiltinEnum<SegmenterPrototype>
    {
        resolvedOptions(0),
        segment(1);

        private final int length;

        private SegmenterPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

